﻿//////////////////////////////////////////////
// Entity.h	
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Mesh ;
	class Node ;
	class RenderQueue ;
	class Shader ;
}

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Bounds/BoundingBox.h"

#include "EntityRenderInfo.h"

// nkExport
#include <NilkinsExport/Exportable/Exportable.h>

// Standards
#include <vector>

/// Class ------------------------------------

namespace nkGraphics
{	
	class DLL_GRAPHICS_EXPORT Entity final : public nkExport::Exportable
	{		
		public :
		
			// Getters
			const EntityRenderInfo& getRenderInfo () const ;
			EntityRenderInfo& getRenderInfo () ;
			Node* getParentNode () const ;
			RenderQueue* getRenderQueue () const ;
			void* getUserData () const ;

			// Setters
			void setRenderInfo (const EntityRenderInfo& info) ;
			void setParentNode (Node* parent) ;
			void setDirtyNodeTransform (bool value) ;
			void setUserData (void* value) ;

			// Updates
			void updateMeshBinding (Mesh* oldMesh) ;

			// Import / Export
			virtual void exportClassToTree (nkExport::Node* rootNode) override ;
			virtual void importClassFromTree (nkExport::Node* rootNode) override ;

		private :

			// Functions
			// Constructor, destructor
			Entity (RenderQueue* parentRenderQueue) noexcept ;
			~Entity () ;

		private :
		
			// Attributes
			// Associated rendering info
			EntityRenderInfo _renderInfo ;

			// Parents
			Node* _parentNode ;
			RenderQueue* _renderQueue ;

			// User info (to help with instance slots)
			void* _userData ;

		private :

			friend class RenderQueue ;
	} ;
}